/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.surround.query;

import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.queries.spans.SpanNearQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queryparser.surround.query.BasicQueryFactory;
import guideme.internal.shaded.lucene.queryparser.surround.query.ComposedQuery;
import guideme.internal.shaded.lucene.queryparser.surround.query.DistanceRewriteQuery;
import guideme.internal.shaded.lucene.queryparser.surround.query.DistanceSubQuery;
import guideme.internal.shaded.lucene.queryparser.surround.query.SpanNearClauseFactory;
import guideme.internal.shaded.lucene.queryparser.surround.query.SrndQuery;
import guideme.internal.shaded.lucene.search.MatchNoDocsQuery;
import guideme.internal.shaded.lucene.search.Query;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DistanceQuery
extends ComposedQuery
implements DistanceSubQuery {
    private int opDistance;
    private boolean ordered;

    public DistanceQuery(List<SrndQuery> queries, boolean infix, int opDistance, String opName, boolean ordered) {
        super(queries, infix, opName);
        this.opDistance = opDistance;
        this.ordered = ordered;
    }

    public int getOpDistance() {
        return this.opDistance;
    }

    public boolean subQueriesOrdered() {
        return this.ordered;
    }

    @Override
    public String distanceSubQueryNotAllowed() {
        Iterator<SrndQuery> sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            SrndQuery leq = sqi.next();
            if (leq instanceof DistanceSubQuery) {
                DistanceSubQuery dsq = (DistanceSubQuery)((Object)leq);
                String m = dsq.distanceSubQueryNotAllowed();
                if (m == null) continue;
                return m;
            }
            return "Operator " + this.getOperatorName() + " does not allow subquery " + ((Object)leq).toString();
        }
        return null;
    }

    @Override
    public void addSpanQueries(SpanNearClauseFactory sncf) throws IOException {
        Query snq = this.getSpanNearQuery(sncf.getIndexReader(), sncf.getFieldName(), sncf.getBasicQueryFactory());
        sncf.addSpanQuery(snq);
    }

    public Query getSpanNearQuery(IndexReader reader, String fieldName, BasicQueryFactory qf) throws IOException {
        SpanQuery[] spanClauses = new SpanQuery[this.getNrSubQueries()];
        Iterator<SrndQuery> sqi = this.getSubQueriesIterator();
        int qi = 0;
        while (sqi.hasNext()) {
            SpanNearClauseFactory sncf = new SpanNearClauseFactory(reader, fieldName, qf);
            ((DistanceSubQuery)((Object)sqi.next())).addSpanQueries(sncf);
            if (sncf.size() == 0) {
                while (sqi.hasNext()) {
                    ((DistanceSubQuery)((Object)sqi.next())).addSpanQueries(sncf);
                    sncf.clear();
                }
                return new MatchNoDocsQuery();
            }
            spanClauses[qi] = sncf.makeSpanClause();
            ++qi;
        }
        return new SpanNearQuery(spanClauses, this.getOpDistance() - 1, this.subQueriesOrdered());
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(String fieldName, BasicQueryFactory qf) {
        return new DistanceRewriteQuery(this, fieldName, qf);
    }
}

